<?php
require 'config.php';
include 'navbar.php';

// معالجة حذف جميع العملاء بعد إدخال كلمة السر
$delete_message = '';
if(isset($_POST['delete_all_password'])){
    $password = $_POST['delete_all_password'];
    if($password === '159'){
        try {
            $conn->query("DELETE FROM balance_history");
            $conn->query("DELETE FROM customers");
            $delete_message = "✅ تم حذف جميع العملاء وسجلاتهم بنجاح.";
        } catch (Exception $e){
            $delete_message = "❌ حدث خطأ أثناء الحذف: " . $e->getMessage();
        }
    } else {
        $delete_message = "❌ كلمة السر غير صحيحة.";
    }
}

// التصفية والترتيب
$order = isset($_GET['order']) && $_GET['order'] === 'desc' ? 'DESC' : 'ASC';
$rep_filter = isset($_GET['rep_filter']) ? $_GET['rep_filter'] : '';

// بناء شرط WHERE إذا تم اختيار مندوب معين
$where = "";
$params = [];
if ($rep_filter && $rep_filter !== 'all') {
    $where = "WHERE representative = ?";
    $params[] = $rep_filter;
}

// جلب بيانات العملاء مع الترتيب
$stmt = $conn->prepare("SELECT * FROM customers $where ORDER BY balance $order");
$stmt->execute($params);
$customers = $stmt->fetchAll(PDO::FETCH_ASSOC);

// إحصائيات عامة
$stmt = $conn->query("SELECT COUNT(*) AS total_customers, SUM(balance) AS total_balance FROM customers");
$stats = $stmt->fetch(PDO::FETCH_ASSOC);

// جلب أعلى وأقل رصيد بعد التصفية
$stmt = $conn->prepare("SELECT name, balance FROM customers $where ORDER BY balance DESC LIMIT 1");
$stmt->execute($params);
$highest = $stmt->fetch(PDO::FETCH_ASSOC);

$stmt = $conn->prepare("SELECT name, balance FROM customers $where ORDER BY balance ASC LIMIT 1");
$stmt->execute($params);
$lowest = $stmt->fetch(PDO::FETCH_ASSOC);

// جلب المندوبين لإظهارهم في القائمة
$stmt = $conn->query("SELECT DISTINCT representative FROM customers");
$all_reps = $stmt->fetchAll(PDO::FETCH_COLUMN);

// إحصائيات المندوبين
$stmt = $conn->query("SELECT representative, SUM(balance) AS total_balance FROM customers GROUP BY representative");
$representatives_stats = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="UTF-8">
<title>قائمة العملاء</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
.card-rep {
    height: 120px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: #000;
    font-weight: bold;
}
.card-rep .inner {
    width: 100%;
    height: 100%;
    display: flex;
}
.card-rep .inner div {
    flex: 1;
    display: flex;
    align-items: center;
    justify-content: center;
}
</style>
</head>
<body class="container mt-4">

<h2 class="mb-4 text-center">قائمة العملاء</h2>

<!-- نموذج التصفية والترتيب -->
<form method="get" class="row g-2 mb-3">
    <div class="col-md-4">
        <label>ترتيب حسب الرصيد:</label>
        <select name="order" class="form-select" onchange="this.form.submit()">
            <option value="asc" <?= $order==='ASC'?'selected':'' ?>>تصاعدي</option>
            <option value="desc" <?= $order==='DESC'?'selected':'' ?>>تنازلي</option>
        </select>
    </div>
    <div class="col-md-4">
        <label>تصفية حسب المندوب:</label>
        <select name="rep_filter" class="form-select" onchange="this.form.submit()">
            <option value="all">الكل</option>
            <?php foreach($all_reps as $rep): ?>
                <option value="<?= htmlspecialchars($rep) ?>" <?= $rep_filter===$rep?'selected':'' ?>><?= htmlspecialchars($rep) ?></option>
            <?php endforeach; ?>
        </select>
    </div>
</form>

<?php if($delete_message) echo "<div class='alert alert-info'>$delete_message</div>"; ?>

<!-- زر حذف جميع العملاء -->
<button type="button" class="btn btn-danger mb-3" data-bs-toggle="modal" data-bs-target="#deleteAllModal">
    حذف جميع العملاء
</button>

<!-- مودال حذف جميع العملاء -->
<div class="modal fade" id="deleteAllModal" tabindex="-1" aria-labelledby="deleteAllModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <form method="post">
        <div class="modal-header">
          <h5 class="modal-title" id="deleteAllModalLabel">تأكيد حذف جميع العملاء</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="إغلاق"></button>
        </div>
        <div class="modal-body">
          <p>أدخل كلمة السر لتأكيد الحذف:</p>
          <input type="password" name="delete_all_password" class="form-control" placeholder="كلمة السر" required>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
          <button type="submit" class="btn btn-danger">تأكيد الحذف</button>
        </div>
      </form>
    </div>
  </div>
</div>

<!-- الإحصائيات العامة -->
<div class="row mb-4 text-center">
    <div class="col-md-3">
        <div class="card bg-primary text-white p-3">
            <h6>عدد العملاء</h6>
            <h4><?= $stats['total_customers'] ?></h4>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card bg-success text-white p-3">
            <h6>مجموع الرصيد</h6>
            <h4><?= number_format($stats['total_balance'],2) ?></h4>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card bg-warning text-dark p-3">
            <h6>أعلى رصيد</h6>
            <h5><?= htmlspecialchars($highest['name']) ?></h5>
            <h4><?= number_format($highest['balance'],2) ?></h4>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card bg-danger text-white p-3">
            <h6>أقل رصيد</h6>
            <h5><?= htmlspecialchars($lowest['name']) ?></h5>
            <h4><?= number_format($lowest['balance'],2) ?></h4>
        </div>
    </div>
</div>

<!-- كارتات المندوبين -->
<div class="row mb-4">
    <?php 
    $colors = [
        "محمد" => ["#C0C0FF","#FFFF00"],
        "دجوار" => ["#00FFFF"],
        "زبائن مجمدة" => ["#FF0000"],
        "أحمد" => ["#A8FD53"]
    ];
    foreach($representatives_stats as $stat): 
        $rep = $stat['representative'];
        if(!$rep || $rep === "غير محدد") continue;
        $repColors = $colors[$rep] ?? ["#CCCCCC"];
    ?>
    <div class="col-md-3 mb-3">
        <div class="card shadow-sm border-0 text-center p-2">
            <div class="d-flex">
                <?php foreach($repColors as $color): ?>
                    <div style="flex: 1; height: 50px; background-color: <?= $color ?>;"></div>
                <?php endforeach; ?>
            </div>
            <h6 class="mt-2"><?= htmlspecialchars($rep) ?></h6>
            <p class="mb-0">المستحق: <?= number_format($stat['total_balance'], 2) ?> ₺</p>
        </div>
    </div>
    <?php endforeach; ?>
</div>

<!-- جدول العملاء -->
<table class="table table-bordered table-striped">
    <thead class="table-dark">
        <tr>
            <th>الاسم</th>
            <th>الرصيد</th>
            <th>العنوان</th>
            <th>الهاتف</th>
            <th>المندوب</th>
            <th>تعديل</th>
            <th>حذف</th>
        </tr>
    </thead>
    <tbody>
        <?php foreach($customers as $c): ?>
        <tr>
            <td><?= htmlspecialchars($c['name']) ?></td>
            <td><?= number_format($c['balance'],2) ?></td>
            <td><?= htmlspecialchars($c['address']) ?></td>
            <td><?= htmlspecialchars($c['phone']) ?></td>
            <td><?= htmlspecialchars($c['representative']) ?></td>
            <td><a href="edit_customer.php?id=<?= $c['id'] ?>" class="btn btn-warning btn-sm">تعديل</a></td>
            <td><a href="delete_customer.php?id=<?= $c['id'] ?>" class="btn btn-danger btn-sm" onclick="return confirm('هل أنت متأكد من الحذف؟');">حذف</a></td>
        </tr>
        <?php endforeach; ?>
    </tbody>
</table>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
