<?php
require_once __DIR__ . '/vendor/autoload.php';
use Mpdf\Mpdf;
use PHPMailer\PHPMailer\PHPMailer;
include 'config.php';

function parseOrder($text){
    $lines = array_values(array_filter(array_map('trim', explode("\n", $text))));
    if(count($lines) == 0) return null;
    $last = array_pop($lines); // نفترض آخر سطر اسم العميل
    $first = isset($lines[0]) ? $lines[0] : $last;

    // كمية: رقم (قد يحتوي على .) متبوع بكلمات كغ او kg او كجم
    if(preg_match('/([\d\.,]+)\s*(كغ|كجم|kg|KG|Kg)/u', $first, $m)) {
        $quantity = floatval(str_replace(',','.', $m[1]));
    } else if (preg_match('/^([\d\.,]+)/', $first, $m)) {
        $quantity = floatval(str_replace(',','.', $m[1]));
    } else $quantity = 0;

    // سعر: بعد كلمة سعر أو قبل $ أو بعد الرمز
    if(preg_match('/سعر\s*([\d\.,]+)/u', $first, $m)) {
        $price = floatval(str_replace(',','.', $m[1]));
    } else if (preg_match('/([\d\.,]+)\s*\$/', $first, $m)) {
        $price = floatval(str_replace(',','.', $m[1]));
    } else if (preg_match('/\s([\d\.,]+)$/', $first, $m)) {
        $price = floatval(str_replace(',','.', $m[1]));
    } else $price = 0;

    // اسم المادة = السطر الأول بدون الكمية وبدون السعر
    $product = preg_replace(['/([\d\.,]+)\s*(كغ|كجم|kg|KG|Kg)/u','/سعر\s*[\d\.,]+/u','/[\d\.,]+\s*\$/u','/[\d\.,]+$/u'],'',$first);
    $product = trim($product);

    return [
        'customer_text' => $last,
        'product_text' => $product,
        'quantity' => $quantity,
        'price' => $price,
        'total' => $quantity * $price
    ];
}

// عند الإرسال
$msg = '';
if($_SERVER['REQUEST_METHOD'] === 'POST'){
    $text = $_POST['order_text'] ?? '';
    $parsed = parseOrder($text);
    if(!$parsed) { $msg = "نص الطلب غير صالح"; }
    else {
        // بحث ذكي عن العميل في DB (LIKE)
        $search = '%' . str_replace(' ', '%', $parsed['customer_text']) . '%';
        $stmt = $conn->prepare("SELECT * FROM customers WHERE name LIKE ? OR code LIKE ? LIMIT 1");
        $stmt->execute([$search, $search]);
        $customer = $stmt->fetch(PDO::FETCH_ASSOC);

        // إذا لم يوجد العميل: نضيفه تلقائياً (يمكن تعديل لاحقاً)
        if(!$customer){
            $code = 'C' . time();
            $stmtIns = $conn->prepare("INSERT INTO customers (code,name,balance,address,phone) VALUES (?,?,?,?,?)");
            $stmtIns->execute([$code, $parsed['customer_text'], 0, '', '']);
            $customer_id = $conn->lastInsertId();
            $customer = ['id'=>$customer_id,'code'=>$code,'name'=>$parsed['customer_text'],'balance'=>0,'address'=>'','phone'=>''];
        }

        // بحث عن المنتج بالمطابقة الجزئية
        $searchP = '%' . str_replace(' ', '%', $parsed['product_text']) . '%';
        $stmtP = $conn->prepare("SELECT * FROM products WHERE name LIKE ? LIMIT 1");
        $stmtP->execute([$searchP]);
        $product = $stmtP->fetch(PDO::FETCH_ASSOC);

        // إذا لم يوجد المنتج: نضيفه تلقائياً بسعر من النص
        if(!$product){
            $stmtInsP = $conn->prepare("INSERT INTO products (name,unit_price,unit) VALUES (?,?,?)");
            $unit = 'كغ';
            $stmtInsP->execute([$parsed['product_text'], $parsed['price'], $unit]);
            $product_id = $conn->lastInsertId();
            $product = ['id'=>$product_id,'name'=>$parsed['product_text'],'unit_price'=>$parsed['price'],'unit'=>$unit];
        }

        // الآن نحفظ الوصل ونجري نفس خطوات حفظ + توليد PDF
        $stmtD = $conn->prepare("INSERT INTO deliveries (customer_id,total) VALUES (?,?)");
        $stmtD->execute([$customer['id'],$parsed['total']]);
        $delivery_id = $conn->lastInsertId();

        $stmtItem = $conn->prepare("INSERT INTO delivery_items (delivery_id,product_id,quantity,unit_price,total) VALUES (?,?,?,?,?)");
        $stmtItem->execute([$delivery_id,$product['id'],$parsed['quantity'],$parsed['price'],$parsed['total']]);

        // توليد PDF
        $html = '<div style="font-family:tahoma;direction:rtl;padding:10px;">';
        $html .= '<table width="100%"><tr>';
        $html .= '<td><img src="assets/logo.png" width="80"></td>';
        $html .= '<td style="text-align:center"><h2>اسم شركتك</h2><div>العنوان: ...</div><div>الهاتف: ...</div></td>';
        $html .= '</tr></table><hr>';
        $html .= '<h3 style="text-align:center">وصل تسليم</h3>';
        $html .= '<p>رقم العميل: '.htmlspecialchars($customer['code']).'<br>الاسم: '.htmlspecialchars($customer['name']).'</p>';
        $html .= '<table width="100%" border="1" cellpadding="5"><tr><th>المادة</th><th>الكمية</th><th>السعر</th><th>الإجمالي</th></tr>';
        $html .= '<tr><td>'.htmlspecialchars($product['name']).'</td><td>'.$parsed['quantity'].'</td><td>'.number_format($parsed['price'],2).'</td><td>'.number_format($parsed['total'],2).'</td></tr>';
        $html .= '<tr><td colspan="3" style="text-align:right"><strong>الإجمالي الكلي</strong></td><td>'.number_format($parsed['total'],2).'</td></tr>';
        $html .= '</table><p style="margin-top:30px">توقيع: __________________</p>';
        $html .= '</div>';

        $mpdf = new Mpdf(['format'=>'A5']);
        $mpdf->WriteHTML($html);
        $filename = 'quick_'.$delivery_id.'_'.time().'.pdf';
        $filepath = $PDF_DIR . '/' . $filename;
        $mpdf->Output($filepath, \Mpdf\Output\Destination::FILE);

        // إرسال إلى طابعة الكلاود إن وُجد
        if(!empty($PRINTER_EMAIL) && !empty($SMTP_HOST)) {
            $mail = new PHPMailer(true);
            try {
                $mail->isSMTP(); $mail->Host = $SMTP_HOST; $mail->SMTPAuth = true;
                $mail->Username = $SMTP_USER; $mail->Password = $SMTP_PASS;
                $mail->SMTPSecure = $SMTP_SECURE; $mail->Port = $SMTP_PORT;
                $mail->setFrom($SMTP_USER, 'DeltaWeb ALJ');
                $mail->addAddress($PRINTER_EMAIL);
                $mail->Subject = "وصل سريع #$delivery_id";
                $mail->Body = "وصل تسليم رقم $delivery_id مرفق.";
                $mail->addAttachment($filepath);
                $mail->send();
                $msg = "تم تحويل الطلب إلى وصل وطُبع عبر الكلاود (أو أرسِل إلى الطابعة).";
            } catch (Exception $e) {
                $msg = "توليد الوصل تم، لكن خطأ أثناء إرسال البريد: " . $mail->ErrorInfo;
            }
        } else {
            $msg = "تم توليد الوصل وحفظه على السيرفر: $filename";
        }
    }
}
?>
<!DOCTYPE html><html lang="ar"><head><meta charset="utf-8"><title>إدخال سريع</title>
<style>body{font-family:Tahoma;direction:rtl;padding:15px} textarea{width:100%;height:120px}</style>
</head><body>
<a href="index.php">← رجوع</a><h2>إدخال سريع (أدخل نص الطلب ثم اضغط إرسال)</h2>
<p>مثال: <br>3000 كغ قهوة روبوستا فيتنامي سعر 6.300$<br>Atmaca kahve</p>
<?php if(!empty($msg)) echo "<p style='color:green;'>$msg</p>"; ?>
<form method="post">
<textarea name="order_text" placeholder="ألصق هنا نص الطلب..."></textarea><br>
<button type="submit">إرسال</button>
</form>
</body></html>
