<?php
require 'config.php';
require __DIR__ . '/vendor/autoload.php';
use PhpOffice\PhpSpreadsheet\IOFactory;

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['file'])) {
    $file = $_FILES['file']['tmp_name'];

    try {
        $spreadsheet = IOFactory::load($file);
        $sheet = $spreadsheet->getActiveSheet();

        echo "<h3>قائمة الأكواد المستخرجة من العمود A:</h3><ul>";
        foreach ($sheet->getRowIterator() as $rowIndex => $row) {
            if ($rowIndex == 1) continue; // تخطي العناوين
            $cell = "A{$rowIndex}";
            $value = $sheet->getCell($cell)->getValue();
            if (!$value) continue;

            $color = $sheet->getStyle($cell)->getFill()->getStartColor()->getRGB();
            echo "<li>الصف $rowIndex - الاسم: " . htmlspecialchars($value) . " - الكود: $color</li>";
        }
        echo "</ul>";
    } catch (Exception $e) {
        echo "❌ خطأ: " . $e->getMessage();
    }
} else {
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head><meta charset="UTF-8"><title>اختبار الألوان</title></head>
<body>
<h3>رفع ملف Excel لاستخراج كود اللون</h3>
<form method="post" enctype="multipart/form-data">
    <input type="file" name="file" accept=".xlsx" required>
    <button type="submit">رفع</button>
</form>
</body>
</html>
<?php } ?>
