<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
session_start();
include 'includes/functions.php';
?>

<!DOCTYPE html>
<html lang="ar">
<head>
<meta charset="UTF-8">
<title>📦 سجل دفعات الشراء</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
    body { background: #f7f7f7; }
    .table thead { background-color: #343a40; color: white; }
    .table td, .table th { vertical-align: middle; }
    .card { border-radius: 12px; box-shadow: 0 3px 8px rgba(0,0,0,0.1); }
</style>
</head>
<body dir="rtl">

<?php include 'includes/navbar.php'; ?>

<div class="container py-4">
    <h3 class="text-primary mb-4">📦 سجل دفعات الشراء</h3>

    <?php
    // إن تم اختيار مادة لعرض دفعاتها
    if (isset($_GET['product_id'])) {
        $product_id = (int)$_GET['product_id'];

        // جلب بيانات المادة
        $stmt = $pdo->prepare("SELECT * FROM products WHERE id = ?");
        $stmt->execute([$product_id]);
        $product = $stmt->fetch();

        if (!$product) {
            echo "<div class='alert alert-danger'>❌ لم يتم العثور على المادة المطلوبة.</div>";
        } else {
            echo "<div class='card mb-4 p-3'>";
            echo "<h5>📄 المادة: <span class='text-success'>{$product['name']}</span></h5>";
            echo "<p>المخزون الحالي: <b>{$product['stock']}</b> {$product['unit']}</p>";
            echo "</div>";

            // جلب دفعات الشراء
            $stmt = $pdo->prepare("SELECT * FROM product_batches WHERE product_id = ? ORDER BY id DESC");
            $stmt->execute([$product_id]);
            $batches = $stmt->fetchAll();

            if (!$batches) {
                echo "<div class='alert alert-warning'>لا توجد دفعات مسجلة لهذه المادة.</div>";
            } else {
                echo "<div class='table-responsive'>";
                echo "<table class='table table-bordered table-striped text-center bg-white'>";
                echo "<thead><tr>
                        <th>🔢 رقم الدفعة</th>
                        <th>📦 الكمية الأصلية (KG)</th>
                        <th>📉 الكمية المتبقية</th>
                        <th>💰 السعر لكل كيلو</th>
                        <th>📅 تاريخ الإضافة</th>
                      </tr></thead><tbody>";
                foreach ($batches as $b) {
                    echo "<tr>
                            <td>{$b['id']}</td>
                            <td>{$b['quantity']}</td>
                            <td>{$b['remaining']}</td>
                            <td>{$b['price_per_kg']}</td>
                            <td>{$b['created_at']}</td>
                          </tr>";
                }
                echo "</tbody></table></div>";
            }
        }
        echo "<a href='batches.php' class='btn btn-secondary mt-3'>⬅️ رجوع</a>";
    } else {
        // عرض جميع المواد لاختيار مادة لعرض دفعاتها
        $products = $pdo->query("SELECT * FROM products ORDER BY name ASC")->fetchAll();

        if (!$products) {
            echo "<div class='alert alert-warning'>لم يتم العثور على مواد.</div>";
        } else {
            echo "<div class='table-responsive'>";
            echo "<table class='table table-bordered text-center bg-white shadow-sm'>";
            echo "<thead><tr>
                    <th>📦 المادة</th>
                    <th>📊 الكمية</th>
                    <th>🔍 عرض الدفعات</th>
                  </tr></thead><tbody>";
            foreach ($products as $p) {
                echo "<tr>
                        <td>{$p['name']}</td>
                        <td>{$p['stock']}</td>
                        <td><a href='batches.php?product_id={$p['id']}' class='btn btn-primary btn-sm'>عرض</a></td>
                      </tr>";
            }
            echo "</tbody></table></div>";
        }
    }
    ?>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
