<?php
include 'includes/functions.php';
require_once __DIR__ . '/generate_invoice_pdf.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $company_id = $_POST['company'] ?? null;
    $items = $_POST['items'] ?? [];
    $prices = $_POST['prices'] ?? [];
    $quantities = $_POST['quantities'] ?? [];
    $currency = $_POST['currency'] ?? 'TL';

    $total = 0;
    $profit = 0;

    // جلب بيانات الشركة الأصلية (اسم الشركة يظهر في PDF)
    $stmt = $pdo->prepare("SELECT * FROM companies WHERE id=?");
    $stmt->execute([$company_id]);
    $company = $stmt->fetch();

    // إنشاء سجل الفاتورة الأساسية
    $pdo->prepare("INSERT INTO invoices (company_id, total, profit, currency, status) VALUES (?,0,0,?,'pending')")
        ->execute([$company_id, $currency]);
    $invoice_id = $pdo->lastInsertId();

    $invoice_items = [];

    foreach ($items as $i => $pid) {
        $price = (float)$prices[$i];
        $qty = (float)$quantities[$i];

        $stmtStock = $pdo->prepare("SELECT name FROM products WHERE id=?");
        $stmtStock->execute([$pid]);
        $product = $stmtStock->fetch();

        if (!$product) continue;

        $total += $price * $qty;

        $pdo->prepare("
            INSERT INTO invoice_items (invoice_id, product_id, quantity, price, cost_per_unit)
            VALUES (?,?,?,?,?)
        ")->execute([$invoice_id, $pid, $qty, $price, 0]);

        $invoice_items[] = [
            'name' => $product['name'],
            'quantity' => $qty,
            'price' => $price
        ];
    }

    $pdo->prepare("UPDATE invoices SET total=?, profit=? WHERE id=?")
        ->execute([$total, $profit, $invoice_id]);

    $file = generateInvoicePDF($invoice_id, $company, $invoice_items, $total, $currency);
    $pdf_web_path = 'invoices/invoice_' . $invoice_id . '.pdf';

    echo "<div class='alert alert-success text-center mt-4'>
        ✅ تم إنشاء الفاتورة بنجاح<br>
        💵 الإجمالي: <b>{$total} {$currency}</b><br>
        <a href='$pdf_web_path' target='_blank' class='btn btn-success mt-3'>📄 عرض PDF</a>
    </div>";
}
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="UTF-8">
<title>إنشاء فاتورة</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

<!-- ✅ مكتبة Select2 -->
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<script src="https://cdn.jsdelivr.net/npm/jquery@3.6.4/dist/jquery.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

<style>
body { background-color: #f8f9fa; font-family: 'Cairo', sans-serif; }
h3 { color: #0d6efd; margin-bottom: 25px; font-weight:700; }
.card-form { background: #fff; padding: 25px; border-radius: 12px; box-shadow: 0 5px 15px rgba(0,0,0,0.05); }
.invoice-item { display: flex; gap: 10px; margin-bottom: 12px; align-items: center; }
.select2-container .select2-selection--single {
    height: 38px; border-radius: 6px; border: 1px solid #ced4da;
}
.select2-container--default .select2-results>.select2-results__options {
    max-height: 200px;
}
</style>
</head>
<body>
<?php include 'includes/navbar.php'; ?>

<div class="container py-5">
    <div class="card-form">
        <h3 class="text-center">➕ إنشاء فاتورة جديدة</h3>

        <form method="POST">
            <!-- ✅ اختيار الشركة -->
            <div class="mb-4">
                <label class="form-label">الشركة (يظهر اسم المستخدم فقط هنا)</label>
                <select id="companySelect" name="company" class="form-select" required>
                    <option value="">اختر الشركة...</option>
                    <?php 
                    $companies = $pdo->query("SELECT * FROM companies ORDER BY alici_adi ASC")->fetchAll();
                    foreach($companies as $c): 
                        $username = trim($c['username']);
                        $company_name = trim($c['alici_adi']);
                        
                        // إذا يوجد username → نعرضه، وإذا لا يوجد نعرض اسم الشركة كبديل
                        $display_name = !empty($username) ? $username : $company_name;
                    ?>
                        <option value="<?= $c['id'] ?>">
                            <?= htmlspecialchars($display_name) ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>

            <!-- ✅ المنتجات -->
            <div id="items-container">
                <div class="invoice-item">
                    <select name="items[]" class="form-select" required style="flex:3">
                        <option value="">اختر المادة</option>
                        <?php foreach($pdo->query("SELECT * FROM products") as $p): ?>
                        <option value="<?= $p['id'] ?>"><?= htmlspecialchars($p['name']) ?> (مخزون: <?= $p['stock'] ?>)</option>
                        <?php endforeach; ?>
                    </select>

                    <input type="number" name="quantities[]" placeholder="الكمية" class="form-control" required style="flex:1;" step="0.01">
                    <input type="number" name="prices[]" placeholder="السعر" class="form-control" required style="flex:1;" step="0.01">
                    <button type="button" class="btn btn-outline-danger remove-btn" onclick="removeItem(this)">❌</button>
                </div>
            </div>

            <button type="button" class="btn btn-outline-primary mb-3" onclick="addItem()">➕ إضافة منتج</button>

            <div class="mb-4">
                <label class="form-label">العملة</label>
                <select name="currency" class="form-select" required>
                    <option value="TL">ليرة تركية (TL)</option>
                    <option value="USD">دولار ($)</option>
                </select>
            </div>

            <button type="submit" class="btn btn-primary w-100">إنشاء الفاتورة</button>
        </form>
    </div>
</div>

<script>
// ✅ تفعيل البحث داخل القائمة باستخدام Select2
$(document).ready(function() {
    $('#companySelect').select2({
        placeholder: 'ابحث باسم المستخدم أو الشركة...',
        width: '100%',
        allowClear: true,
        language: {
            noResults: () => "لا توجد نتائج"
        }
    });
});

// ✅ إضافة / حذف منتج
function addItem() {
    const container = document.getElementById('items-container');
    const first = container.children[0];
    const clone = first.cloneNode(true);
    clone.querySelectorAll('input').forEach(i => i.value = '');
    clone.querySelector('select').selectedIndex = 0;
    container.appendChild(clone);
}

function removeItem(btn){
    const container = document.getElementById('items-container');
    if(container.children.length > 1){
        btn.closest('.invoice-item').remove();
    } else {
        alert('يجب أن تحتوي الفاتورة على منتج واحد على الأقل');
    }
}
</script>
</body>
</html>
