<?php
// ✅ تشغيل الجلسة مرة واحدة فقط إذا لم تكن فعالة
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// 🔒 كلمة المرور العامة للموقع
define('SITE_PASSWORD', '12345');

// دالة التحقق من تسجيل الدخول
function check_login() {
    if (empty($_SESSION['logged_in']) || $_SESSION['logged_in'] !== true) {
        $current = $_SERVER['REQUEST_URI'];
        // لا يوجد أي مخرجات قبل هذا السطر
        header("Location: login.php?redirect=" . urlencode($current));
        exit;
    }
}

// ✅ لا يتم تطبيق الحماية على صفحات login أو logout
$currentFile = basename($_SERVER['PHP_SELF']);
if (!in_array($currentFile, ['login.php', 'logout.php'])) {
    check_login();
}

// ------------------ اتصال قاعدة البيانات ------------------
$pdo = new PDO(
    "mysql:host=localhost;dbname=deltaweb_invoice;charset=utf8mb4",
    "deltaweb_invoice",
    "deltaweb_invoice"
);
$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

// ------------------ دالة إنشاء PDF ------------------
function createInvoicePDF($invoice_no, $company, $items, $total, $currency="TL") {
    require_once(__DIR__ . '/../vendor/tcpdf/tcpdf.php');
    $pdf = new TCPDF();
    $pdf->SetFont('dejavusans', '', 12);
    $pdf->AddPage();

    $html = "<h2>فاتورة رقم: $invoice_no</h2>";
    $html .= "<b>ALICI ADI:</b> {$company['alici_adi']}<br>";
    $html .= "<b>ALICI ADRESI:</b> {$company['alici_adresi']}<br>";
    $html .= "<b>TESLIM ŞEKLİ:</b> {$company['teslim_sekli']}<br>";
    $html .= "<b>VERGİ DAİRESİ:</b> {$company['vergi_dairesi']}<br>";
    $html .= "<b>VERGİ NUMARASI:</b> {$company['vergi_numarasi']}<br><br>";

    $html .= "<table border='1' cellpadding='5'>
    <tr><th>المنتج</th><th>الكمية</th><th>السعر</th><th>الإجمالي</th></tr>";
    foreach ($items as $item) {
        $sub = $item['quantity'] * $item['price'];
        $html .= "<tr>
        <td>{$item['name']}</td>
        <td>{$item['quantity']}</td>
        <td>{$item['price']}</td>
        <td>$sub</td></tr>";
    }
    $html .= "</table><h3 style='text-align:right'>الإجمالي: $total $currency</h3>";

    $pdf->writeHTML($html);
    $path = __DIR__ . '/../pdf/invoices/';
    if (!file_exists($path)) mkdir($path, 0777, true);
    $file = $path . $invoice_no . ".pdf";
    $pdf->Output($file, 'F');
    return "pdf/invoices/" . $invoice_no . ".pdf";
}
// خصم الكمية FIFO + حساب تكلفة البضاعة المباعة
function reduceStockFIFO($pdo, $product_id, $sold_qty) {
    $stmt = $pdo->prepare("SELECT * FROM product_batches WHERE product_id = ? AND remaining > 0 ORDER BY id ASC");
    $stmt->execute([$product_id]);
    $batches = $stmt->fetchAll(PDO::FETCH_ASSOC);

    $remaining_to_deduct = $sold_qty;
    $total_cost = 0;
    $total_units = 0;

    foreach ($batches as $batch) {
        if ($remaining_to_deduct <= 0) break;

        $use_qty = min($remaining_to_deduct, $batch['remaining']);

        // خصم الكمية من الدفعة
        $stmt2 = $pdo->prepare("UPDATE product_batches SET remaining = remaining - ? WHERE id = ?");
        $stmt2->execute([$use_qty, $batch['id']]);

        // جمع التكلفة
        $total_cost += $use_qty * $batch['price_per_kg'];
        $total_units += $use_qty;
        $remaining_to_deduct -= $use_qty;
    }

    // في حال لم نجد دفعات كافية
    if ($total_units == 0) return 0;

    // نحسب متوسط تكلفة الوحدة
    return $total_cost / $total_units;
}

?>
