<?php 
include 'includes/functions.php'; 

// فلاتر GET
$filter_company = $_GET['company'] ?? '';
$filter_product = $_GET['product'] ?? '';
$filter_currency = $_GET['currency'] ?? '';
$filter_date_from = $_GET['date_from'] ?? '';
$filter_date_to = $_GET['date_to'] ?? '';

// تجهيز WHERE ديناميكي
$where = [];
$params = [];

if($filter_company){ $where[] = "invoices.company_id = ?"; $params[] = $filter_company; }
if($filter_currency){ $where[] = "invoices.currency = ?"; $params[] = $filter_currency; }
if($filter_date_from){ $where[] = "invoices.created_at >= ?"; $params[] = $filter_date_from.' 00:00:00'; }
if($filter_date_to){ $where[] = "invoices.created_at <= ?"; $params[] = $filter_date_to.' 23:59:59'; }

// فلتر حسب المادة
$join_product = '';
if($filter_product){
    $join_product = "JOIN invoice_items ON invoices.id = invoice_items.invoice_id";
    $where[] = "invoice_items.product_id = ?";
    $params[] = $filter_product;
}

// ✅ عرض فقط الفواتير المقبولة (status = 'approved')
$status_filter = "invoices.status = 'approved'";
$where_sql = $where ? "WHERE $status_filter AND " . implode(" AND ", $where) : "WHERE $status_filter";

$sql = "SELECT DISTINCT invoices.*, companies.alici_adi 
        FROM invoices 
        JOIN companies ON invoices.company_id = companies.id
        $join_product
        $where_sql
        ORDER BY invoices.id DESC";

$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$invoices = $stmt->fetchAll();

// حساب المجاميع
$total_sum = 0;
$sum_by_currency = [];
foreach($invoices as $inv){
    $total_sum += $inv['total'];
    $sum_by_currency[$inv['currency']] = ($sum_by_currency[$inv['currency']] ?? 0) + $inv['total'];
}

// بيانات الفلاتر
$companies = $pdo->query("SELECT * FROM companies")->fetchAll();
$products = $pdo->query("SELECT * FROM products")->fetchAll();
$currencies = ['TL'=>'ليرة تركية','USD'=>'دولار'];
?>

<!DOCTYPE html>
<html lang="ar">
<head>
<meta charset="UTF-8">
<title>📄 الفواتير</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
body { background-color: #f5f6fa; font-family: 'Cairo', sans-serif; }
h3 { margin-bottom:20px; }
.card-summary { border-radius:12px; box-shadow:0 5px 15px rgba(0,0,0,0.05); }
.table tbody tr:hover { background-color: #eef4ff; }
.actions a, .actions button { margin-right:5px; margin-bottom:3px; }
</style>
</head>
<body>
<?php include 'includes/navbar.php'; ?>
<div class="container py-4">

<h3>📄 الفواتير السابقة</h3>

<?php if(isset($_GET['deleted'])): ?>
<div class="alert alert-success">✅ تم حذف الفاتورة بنجاح.</div>
<?php endif; ?>

<!-- بطاقات المجاميع -->
<div class="row mb-4">
    <div class="col-md-6">
        <div class="card text-white bg-primary mb-3 card-summary">
            <div class="card-header">المجموع الكلي</div>
            <div class="card-body">
                <h5 class="card-title"><?= number_format($total_sum,2) ?></h5>
            </div>
        </div>
    </div>
    <div class="col-md-6">
        <div class="card text-dark bg-light mb-3 card-summary">
            <div class="card-header">المجموع حسب العملة</div>
            <div class="card-body">
                <?php foreach($sum_by_currency as $cur=>$sum): ?>
                    <p class="mb-1"><?= $currencies[$cur] ?? $cur ?>: <?= number_format($sum,2) ?></p>
                <?php endforeach; ?>
            </div>
        </div>
    </div>
</div>

<!-- نموذج الفلاتر -->
<form method="GET" class="row g-3 mb-4">
    <div class="col-md-3">
        <label>الشركة</label>
        <select name="company" class="form-select">
            <option value="">الكل</option>
            <?php foreach($companies as $c): ?>
            <option value="<?= $c['id'] ?>" <?= $filter_company==$c['id']?'selected':'' ?>><?= $c['alici_adi'] ?></option>
            <?php endforeach; ?>
        </select>
    </div>
    <div class="col-md-3">
        <label>المادة</label>
        <select name="product" class="form-select">
            <option value="">الكل</option>
            <?php foreach($products as $p): ?>
            <option value="<?= $p['id'] ?>" <?= $filter_product==$p['id']?'selected':'' ?>><?= $p['name'] ?></option>
            <?php endforeach; ?>
        </select>
    </div>
    <div class="col-md-2">
        <label>العملة</label>
        <select name="currency" class="form-select">
            <option value="">الكل</option>
            <?php foreach($currencies as $k=>$v): ?>
            <option value="<?= $k ?>" <?= $filter_currency==$k?'selected':'' ?>><?= $v ?></option>
            <?php endforeach; ?>
        </select>
    </div>
    <div class="col-md-2">
        <label>من تاريخ</label>
        <input type="date" name="date_from" value="<?= $filter_date_from ?>" class="form-control">
    </div>
    <div class="col-md-2">
        <label>إلى تاريخ</label>
        <input type="date" name="date_to" value="<?= $filter_date_to ?>" class="form-control">
    </div>
    <div class="col-md-12 mt-2">
        <button class="btn btn-primary">تطبيق الفلاتر</button>
        <a href="invoices.php" class="btn btn-secondary">مسح الفلاتر</a>
    </div>
</form>

<!-- جدول الفواتير -->
<table class="table table-bordered table-striped align-middle text-center">
<thead class="table-dark">
<tr>
    <th>رقم الفاتورة</th>
    <th>الشركة</th>
    <th>المواد</th>
    <th>الإجمالي</th>
    <th>العملة</th>
    <th>تاريخ الإنشاء</th>
    <th>إجراءات</th>
</tr>
</thead>
<tbody>
<?php foreach($invoices as $inv):
    $file = "invoices/invoice_".$inv['id'].".pdf";

    // جلب المواد الخاصة بالفاتورة
    $stmtItems = $pdo->prepare("SELECT invoice_items.quantity, invoice_items.price, products.name 
                                FROM invoice_items 
                                JOIN products ON invoice_items.product_id = products.id
                                WHERE invoice_id=?");
    $stmtItems->execute([$inv['id']]);
    $items = $stmtItems->fetchAll();

    $items_text = [];
    foreach($items as $item){
        $items_text[] = $item['name'] . " ({$item['quantity']} × {$item['price']})";
    }
?>
<tr>
<td><?= $inv['id'] ?></td>
<td><?= $inv['alici_adi'] ?></td>
<td><?= implode(", ", $items_text) ?></td>
<td><?= number_format($inv['total'],2) ?></td>
<td><?= $inv['currency'] ?></td>
<td><?= $inv['created_at'] ?></td>
<td class="actions">
    <a class="btn btn-warning btn-sm" href="invoice_edit.php?invoice_id=<?= $inv['id'] ?>">✏️ تعديل</a>
    <a class="btn btn-success btn-sm" href="<?= $file ?>" target="_blank">عرض</a>
    <a class="btn btn-primary btn-sm" href="<?= $file ?>" download>تنزيل</a>
    <a class="btn btn-info btn-sm" href="https://api.whatsapp.com/send?phone=+90<?= '5342009435' ?>&text=رابط%20الفاتورة%20<?= urlencode('https://deltaweb.agency/invoice-system/'.$file) ?>" target="_blank">واتساب</a>

    <!-- زر حذف -->
    <form action="invoice_delete.php" method="POST" style="display:inline;" onsubmit="return confirm('هل أنت متأكد أنك تريد حذف هذه الفاتورة؟');">
        <input type="hidden" name="invoice_id" value="<?= $inv['id'] ?>">
        <button type="submit" class="btn btn-danger btn-sm">🗑️ حذف</button>
    </form>
</td>
</tr>
<?php endforeach; ?>
</tbody>
</table>

</div>
</body>
</html>
