<?php
include 'includes/functions.php';
require 'vendor/autoload.php';

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

// استعلام جميع الشركات
$stmt = $pdo->query("SELECT id, alici_adi, alici_adresi, teslim_sekli, vergi_dairesi, vergi_numarasi FROM companies ORDER BY id ASC");
$companies = $stmt->fetchAll(PDO::FETCH_ASSOC);

// إنشاء ملف Excel جديد
$spreadsheet = new Spreadsheet();
$sheet = $spreadsheet->getActiveSheet();
$sheet->setTitle('Companies');

// كتابة العناوين في الصف الأول
$headers = ['ID', 'ALICI ADI', 'ALICI ADRESI', 'TESLIM ŞEKLİ', 'VERGİ DAİRESİ', 'VERGİ NUMARASI'];
$col = 'A';
foreach ($headers as $header) {
    $sheet->setCellValue($col . '1', $header);
    $sheet->getStyle($col . '1')->getFont()->setBold(true);
    $sheet->getColumnDimension($col)->setAutoSize(true);
    $col++;
}

// تعبئة البيانات
$row = 2;
foreach ($companies as $company) {
    $sheet->setCellValue('A' . $row, $company['id']);
    $sheet->setCellValue('B' . $row, $company['alici_adi']);
    $sheet->setCellValue('C' . $row, $company['alici_adresi']);
    $sheet->setCellValue('D' . $row, $company['teslim_sekli']);
    $sheet->setCellValue('E' . $row, $company['vergi_dairesi']);
    $sheet->setCellValue('F' . $row, $company['vergi_numarasi']);
    $row++;
}

// تنسيق الصف الأول (العناوين)
$sheet->getStyle('A1:F1')->getFont()->setBold(true);
$sheet->getStyle('A1:F1')->getFill()
    ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
    ->getStartColor()->setARGB('FF007BFF');
$sheet->getStyle('A1:F1')->getFont()->getColor()->setARGB('FFFFFFFF');

// إعداد اسم الملف
$filename = 'companies_' . date('Y-m-d_H-i-s') . '.xlsx';

// إرسال الملف للتحميل
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header("Content-Disposition: attachment; filename=\"$filename\"");
header('Cache-Control: max-age=0');

$writer = new Xlsx($spreadsheet);
$writer->save('php://output');
exit;
