<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
session_start();
include 'includes/functions.php';
require_once('tcpdf/tcpdf.php'); // مكتبة TCPDF

$unit_fixed = "KG";

// ==================== رفع ملفات Excel ====================
if (isset($_POST['upload'])) {
    if (is_uploaded_file($_FILES['excel']['tmp_name'])) {
        require_once('includes/simplexlsx-master/src/SimpleXLSX.php');
        if ($xlsx = SimpleXLSX::parse($_FILES['excel']['tmp_name'])) {
            foreach ($xlsx->rows() as $index => $row) {
                if ($index == 0) continue;
                $name = trim($row[0] ?? '');
                $stock_input = str_replace(',', '.', $row[1] ?? 0);
                $stock = floatval($stock_input);
                if ($name != '') {
                    $stmt = $pdo->prepare("SELECT id FROM products WHERE name = ?");
                    $stmt->execute([$name]);
                    $existingId = $stmt->fetchColumn();
                    if ($existingId) {
                        $stmt = $pdo->prepare("UPDATE products SET stock = ?, unit = ? WHERE id = ?");
                        $stmt->execute([$stock, $unit_fixed, $existingId]);
                    } else {
                        $stmt = $pdo->prepare("INSERT INTO products (name, stock, unit) VALUES (?,?,?)");
                        $stmt->execute([$name, $stock, $unit_fixed]);
                    }
                }
            }
            $_SESSION['msg'] = "✅ تم رفع Excel وتحديث المخازين بنجاح!";
        } else {
            $_SESSION['msg'] = "❌ خطأ في قراءة ملف Excel!";
        }
    }
}

// ==================== إضافة مادة يدويًا ====================
if (isset($_POST['add'])) {
    $name = trim($_POST['name']);
    $stock_input = str_replace(',', '.', $_POST['stock']);
    $stock = floatval($stock_input);
    $stmt = $pdo->prepare("INSERT INTO products (name, stock, unit) VALUES (?,?,?)");
    $stmt->execute([$name, $stock, $unit_fixed]);
    $_SESSION['msg'] = "✅ تم إضافة المادة بنجاح!";
}

// ==================== تعديل المخزون ====================
if (isset($_POST['adjust_stock'])) {
    $id = (int)$_POST['id'];
    $amount_input = str_replace(',', '.', $_POST['amount']);
    $amount = floatval($amount_input);
    $type = $_POST['type'];
    $price_input = isset($_POST['price']) ? str_replace(',', '.', $_POST['price']) : 0;
    $price = floatval($price_input);

    $stmt = $pdo->prepare("SELECT stock FROM products WHERE id = ?");
    $stmt->execute([$id]);
    $currentStock = floatval($stmt->fetchColumn());

    if ($type === 'increase') {
        $stmt = $pdo->prepare("INSERT INTO product_batches (product_id, quantity, remaining, price_per_kg) VALUES (?,?,?,?)");
        $stmt->execute([$id, $amount, $amount, $price]);
        $newStock = $currentStock + $amount;
    } else {
        $newStock = $currentStock - $amount;
        $remainingToDeduct = $amount;
        $stmt = $pdo->prepare("SELECT * FROM product_batches WHERE product_id=? AND remaining>0 ORDER BY id ASC");
        $stmt->execute([$id]);
        $batches = $stmt->fetchAll();
        foreach ($batches as $batch) {
            if ($remainingToDeduct <= 0) break;
            $deduct = min($remainingToDeduct, $batch['remaining']);
            $pdo->prepare("UPDATE product_batches SET remaining=remaining-? WHERE id=?")->execute([$deduct, $batch['id']]);
            $remainingToDeduct -= $deduct;
        }
    }

    $stmt = $pdo->prepare("UPDATE products SET stock = ? WHERE id = ?");
    $stmt->execute([$newStock, $id]);
    $_SESSION['msg'] = "✅ تم تعديل المخزون بنجاح!";
}

// ==================== حذف مادة ====================
if (isset($_POST['delete_product'])) {
    $id = (int)$_POST['id'];
    // حذف الدُفعات أولاً
    $stmt = $pdo->prepare("DELETE FROM product_batches WHERE product_id = ?");
    $stmt->execute([$id]);
    // حذف المادة من جدول المنتجات
    $stmt = $pdo->prepare("DELETE FROM products WHERE id = ?");
    $stmt->execute([$id]);
    $_SESSION['msg'] = "🗑️ تم حذف المادة والمخزون بالكامل!";
}

// ==================== تصدير CSV ====================
if (isset($_POST['export'])) {
    header("Content-Type: text/csv; charset=UTF-8");
    header("Content-Disposition: attachment; filename=products_export.csv");
    echo "\xEF\xBB\xBF";
    echo "اسم المادة,المخزون,الوحدة\n";
    $rows = $pdo->query("SELECT name, stock, unit FROM products")->fetchAll();
    foreach ($rows as $r) {
        $name = str_replace('"', '""', $r['name']);
        echo "\"$name\",\"{$r['stock']}\",\"{$r['unit']}\"\n";
    }
    exit;
}

// ==================== منع إعادة الإرسال ====================
if ($_SERVER['REQUEST_METHOD'] === 'POST' && !isset($_POST['export'])) {
    header("Location: products.php");
    exit;
}

// ==================== جلب المواد ====================
$products = $pdo->query("SELECT * FROM products ORDER BY id DESC")->fetchAll();
?>

<!DOCTYPE html>
<html lang="ar">
<head>
<meta charset="UTF-8">
<title>📦 إدارة المواد</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
body { background: #f5f5f5; }
.table thead { background-color: #343a40; color: #fff; }
.table td, .table th { vertical-align: middle; }
.btn-sm { min-width: 60px; }
.alert { margin-top: 10px; }
.negative-stock { background-color: #ffe6e6 !important; color: #b30000 !important; font-weight: bold; }
</style>
</head>
<body dir="rtl">

<?php include 'includes/navbar.php'; ?>

<div class="container py-4">
<h3 class="mb-4 text-primary">📦 إدارة المواد</h3>

<?php if(isset($_SESSION['msg'])): ?>
<div class="alert alert-success alert-dismissible fade show" role="alert">
<?= $_SESSION['msg'] ?>
<button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
</div>
<?php unset($_SESSION['msg']); ?>
<?php endif; ?>

<form method="POST" class="row g-2 mb-3">
<div class="col-md"><input type="text" name="name" placeholder="اسم المادة" class="form-control" required></div>
<div class="col-md"><input type="text" name="stock" placeholder="المخزون" class="form-control" required></div>
<div class="col-md"><button class="btn btn-primary w-100" name="add">➕ إضافة</button></div>
</form>

<form method="POST" enctype="multipart/form-data" class="mb-3 d-flex gap-2">
<input type="file" name="excel" accept=".xlsx,.xls" class="form-control" required>
<button class="btn btn-success" name="upload">⬆️ رفع Excel</button>
</form>

<form method="POST" class="mb-3">
<button class="btn btn-warning" name="export">⬇️ تصدير Excel (CSV)</button>
</form>

<div class="table-responsive">
<table class="table table-bordered table-striped align-middle text-center bg-white shadow-sm">
<thead>
<tr>
<th>الاسم</th>
<th>المخزون (KG)</th>
<th>تعديل المخزون</th>
<th>حذف</th>
</tr>
</thead>
<tbody>
<?php foreach($products as $p): ?>
<?php $negative = $p['stock'] < 0 ? 'negative-stock' : ''; ?>
<tr class="<?= $negative ?>">
<td><?= htmlspecialchars($p['name'] ?? '') ?></td>
<td><?= $p['stock'] ?><?php if($p['stock'] < 0): ?> ⚠️<?php endif; ?></td>
<td>
<form method="POST" class="d-flex justify-content-center align-items-center gap-1">
<input type="hidden" name="id" value="<?= $p['id'] ?>">
<input type="text" name="amount" value="1" class="form-control form-control-sm w-25" required>
<select name="type" class="form-select form-select-sm w-auto" onchange="togglePriceInput(this)">
<option value="increase">زيادة</option>
<option value="decrease">نقصان</option>
</select>
<input type="text" name="price" placeholder="السعر للكيلو" class="form-control form-control-sm w-25 price-input" required>
<button type="submit" name="adjust_stock" class="btn btn-primary btn-sm">تعديل</button>
</form>
</td>
<td>
<form method="POST" onsubmit="return confirm('هل أنت متأكد أنك تريد حذف هذه المادة مع كل مخزونها؟');">
<input type="hidden" name="id" value="<?= $p['id'] ?>">
<button type="submit" name="delete_product" class="btn btn-danger btn-sm">🗑️ حذف</button>
</form>
</td>
</tr>
<?php endforeach; ?>
</tbody>
</table>
</div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script>
function togglePriceInput(sel) {
    const form = sel.closest('form');
    const priceInput = form.querySelector('.price-input');
    if (sel.value === 'increase') {
        priceInput.style.display = 'block';
        priceInput.required = true;
    } else {
        priceInput.style.display = 'none';
        priceInput.required = false;
    }
}
document.querySelectorAll('select[name="type"]').forEach(sel => togglePriceInput(sel));
</script>
</body>
</html>
