<?php
session_start();
require 'config.php';
if (empty($_SESSION['user'])) header('Location: login.php');

$id = $_GET['id'] ?? 0;

// --- جلب بيانات الحركة ---
$stmt = $pdo->prepare("SELECT m.*, p.name FROM stock_movements m JOIN products p ON p.id=m.product_id WHERE m.id=?");
$stmt->execute([$id]);
$movement = $stmt->fetch();

if (!$movement) die("⚠️ الحركة غير موجودة.");

// --- عند الحفظ ---
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $new_bags = (float)($_POST['bags_count'] ?? 0);
    $new_weight_per_bag = (float)($_POST['weight_per_bag'] ?? 0);
    $new_total_weight = $new_bags * $new_weight_per_bag;

    // بيانات الحركة القديمة
    $old_bags = (float)$movement['bags_count'];
    $old_total_weight = (float)$movement['total_weight'];
    $product_id = $movement['product_id'];

    // جلب المخزون الحالي
    $stock_stmt = $pdo->prepare("SELECT * FROM stock WHERE product_id=? LIMIT 1");
    $stock_stmt->execute([$product_id]);
    $stock = $stock_stmt->fetch();

    if ($stock) {
        // 1️⃣ طرح تأثير الحركة القديمة كلياً
        $bags_after_remove = max(0, (float)$stock['bags_count'] - $old_bags);
        $weight_after_remove = max(0, (float)$stock['total_weight'] - $old_total_weight);

        // تحديث وزن الشوال بعد الطرح
        $weight_per_bag_after_remove = ($bags_after_remove > 0)
            ? $weight_after_remove / $bags_after_remove
            : 0;

        // 2️⃣ إضافة الحركة الجديدة كما لو أضيفت من البداية
        $bags_final = $bags_after_remove + $new_bags;
        $weight_final = $weight_after_remove + $new_total_weight;

        $new_stock_weight_per_bag = ($bags_final > 0)
            ? $weight_final / $bags_final
            : 0;

        // تحديث المخزون
        $pdo->prepare("
            UPDATE stock 
            SET bags_count=?, total_weight=?, weight_per_bag=? 
            WHERE product_id=?
        ")->execute([
            $bags_final,
            $weight_final,
            $new_stock_weight_per_bag,
            $product_id
        ]);
    }

    // تحديث بيانات الحركة نفسها
    $pdo->prepare("
        UPDATE stock_movements 
        SET bags_count=?, total_weight=?, weight_per_bag=? 
        WHERE id=?
    ")->execute([$new_bags, $new_total_weight, $new_weight_per_bag, $id]);

    header("Location: stock.php?updated=1");
    exit;
}
?>

<!doctype html>
<html lang="ar" dir="rtl">
<head>
<meta charset="utf-8">
<title>✏️ تعديل حركة المخزون</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
body { background-color:#f8f9fa; direction:rtl; text-align:right; }
.card { border-radius:15px; }
</style>
</head>
<body>

<div class="container py-5">
  <div class="card p-4 shadow-sm">
    <h4 class="mb-4 text-center">
      ✏️ تعديل حركة المخزون للمنتج: 
      <span class="text-primary"><?=$movement['name']?></span>
    </h4>

    <form method="post">
      <div class="mb-3">
        <label class="form-label">عدد الشوالات</label>
        <input type="number" name="bags_count" id="bags_count" class="form-control" 
               value="<?=$movement['bags_count']?>" min="1" required>
      </div>

      <div class="mb-3">
        <label class="form-label">وزن الشوال (كغ)</label>
        <input type="number" name="weight_per_bag" id="weight_per_bag" class="form-control" 
               step="0.01" value="<?=($movement['bags_count']>0 ? round($movement['total_weight']/$movement['bags_count'],2) : 0)?>" required>
      </div>

      <div class="mb-3">
        <label class="form-label">الوزن الكلي (كغ)</label>
        <input type="text" id="total_weight" class="form-control" readonly 
               value="<?=$movement['total_weight']?>">
      </div>

      <button class="btn btn-primary w-100">💾 حفظ التعديلات</button>
      <a href="stock.php" class="btn btn-secondary w-100 mt-2">🔙 رجوع</a>
    </form>
  </div>
</div>

<script>
// حساب الوزن الكلي تلقائيًا عند تعديل القيم
document.getElementById('bags_count').addEventListener('input', calcTotal);
document.getElementById('weight_per_bag').addEventListener('input', calcTotal);

function calcTotal() {
  const bags = parseFloat(document.getElementById('bags_count').value) || 0;
  const weight = parseFloat(document.getElementById('weight_per_bag').value) || 0;
  document.getElementById('total_weight').value = (bags * weight).toFixed(2);
}
</script>

</body>
</html>
