<?php
require 'config.php';
require 'vendor/autoload.php';
use Dompdf\Dompdf;

$sales = $pdo->query("SELECT s.*, p.name FROM sales s JOIN products p ON p.id=s.product_id ORDER BY s.id DESC")->fetchAll();

$html = '<h3 style="text-align:center;">تقرير المبيعات</h3><table border="1" cellspacing="0" cellpadding="5" width="100%">
<tr style="background:#ffeeba;"><th>المادة</th><th>الشوالات</th><th>الوزن</th><th>السعر</th><th>ملاحظات</th><th>تاريخ</th></tr>';
foreach($sales as $s){
  $html .= "<tr>
    <td>{$s['name']}</td>
    <td>{$s['bags_sold']}</td>
    <td>{$s['weight_sold']}</td>
    <td>{$s['price']}</td>
    <td>{$s['note']}</td>
    <td>{$s['sale_date']}</td>
  </tr>";
}
$html .= '</table>';

$dompdf = new Dompdf();
$dompdf->loadHtml($html, 'UTF-8');
$dompdf->setPaper('A4', 'portrait');
$dompdf->render();
$dompdf->stream('sales_report.pdf', ['Attachment' => true]);
exit;
?>
