<?php
require 'config.php';
require 'vendor/autoload.php';
use Dompdf\Dompdf;

$stock = $pdo->query("SELECT s.*, p.name FROM stock s JOIN products p ON p.id=s.product_id ORDER BY s.id DESC")->fetchAll();

$html = '<h3 style="text-align:center;">تقرير المخزون</h3><table border="1" cellspacing="0" cellpadding="5" width="100%">
<tr style="background:#bee5eb;"><th>المادة</th><th>عدد الشوالات</th><th>الوزن الكلي</th><th>تاريخ الإضافة</th></tr>';
foreach($stock as $s){
  $html .= "<tr>
    <td>{$s['name']}</td>
    <td>{$s['bags_count']}</td>
    <td>{$s['total_weight']}</td>
    <td>{$s['date_added']}</td>
  </tr>";
}
$html .= '</table>';

$dompdf = new Dompdf();
$dompdf->loadHtml($html, 'UTF-8');
$dompdf->setPaper('A4', 'portrait');
$dompdf->render();
$dompdf->stream('stock_report.pdf', ['Attachment' => true]);
exit;
?>
