<?php
require 'config.php';
if (empty($_SESSION['user'])) {
    header('Location: login.php'); 
    exit;
}
?>
<!doctype html>
<html lang="ar" dir="rtl">
<head>
<meta charset="utf-8">
<title>نظام إدارة المخزون</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
    body { background-color: #f8f9fa; }
    .navbar { margin-bottom: 20px; }
    .btn-lg { font-size: 1.1rem; padding: 0.75rem; }
</style>
</head>
<body>
<!-- القائمة العلوية -->
<nav class="navbar navbar-expand-lg navbar-light bg-light shadow-sm">
  <div class="container-fluid">
    <a class="navbar-brand" href="index.php">📦 المخزون</a>
    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
      <span class="navbar-toggler-icon"></span>
    </button>
    <div class="collapse navbar-collapse" id="navbarNav">
      <ul class="navbar-nav ms-auto">
        <li class="nav-item"><a class="nav-link active" href="index.php">الرئيسية</a></li>
        <li class="nav-item"><a class="nav-link" href="products.php">🧱 تسجيل المواد</a></li>
        <li class="nav-item"><a class="nav-link" href="stock.php">📦 إضافة مخزون</a></li>
        <li class="nav-item"><a class="nav-link" href="sales.php">💰 تسجيل المبيعات</a></li>
        <li class="nav-item"><a class="nav-link" href="reports.php">📊 التقارير</a></li>
        <li class="nav-item"><a class="nav-link text-danger" href="logout.php">🚪 خروج</a></li>
      </ul>
    </div>
  </div>
</nav>

<div class="container py-4 text-center">
    <h2 class="mb-4">📦 نظام إدارة المخزون والمبيعات</h2>
    <div class="d-grid gap-3 col-12 col-sm-8 col-md-5 mx-auto">
        <a href="products.php" class="btn btn-success btn-lg">🧱 تسجيل المواد</a>
        <a href="stock.php" class="btn btn-primary btn-lg">📦 إضافة مخزون</a>
        <a href="sales.php" class="btn btn-warning btn-lg">💰 تسجيل المبيعات</a>
        <a href="reports.php" class="btn btn-info btn-lg">📊 التقارير</a>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
