<?php
session_start();
require 'config.php';
if (empty($_SESSION['user'])) header('Location: login.php');

// --- إضافة عملية بيع ---
if ($_SERVER['REQUEST_METHOD']==='POST' && isset($_POST['add_sale'])) {
    $pid = $_POST['product_id'] ?? 0;
    $bags = $_POST['bags_sold'] ?? 0;
    $weight = $_POST['weight_sold'] ?? 0;
    $note = $_POST['note'] ?? '';
    $imagePath = null;

    if (!empty($_FILES['image']['name'])) {
        $file = time() . "_" . basename($_FILES['image']['name']);
        $target = UPLOAD_DIR . $file;
        move_uploaded_file($_FILES['image']['tmp_name'], $target);
        $imagePath = 'uploads/' . $file;
    }

    // حفظ البيع
    $stmt = $pdo->prepare('INSERT INTO sales (product_id, bags_sold, weight_sold, note, image, sale_date) VALUES (?, ?, ?, ?, ?, NOW())');
    $stmt->execute([$pid, $bags, $weight, $note, $imagePath]);

    // خصم من المخزون
    $pdo->prepare('UPDATE stock SET bags_count = bags_count - ?, total_weight = total_weight - ? WHERE product_id = ?')
        ->execute([$bags, $weight, $pid]);

    header("Location: sales.php?success=1");
    exit;
}

// --- حذف ---
if (isset($_GET['delete'])) {
    $id = $_GET['delete'];
    $stmt = $pdo->prepare("SELECT * FROM sales WHERE id=?");
    $stmt->execute([$id]);
    $sale = $stmt->fetch();

    if ($sale) {
        $pid = $sale['product_id'];
        $bags = $sale['bags_sold'];
        $weight = $sale['weight_sold'];

        // إعادة الكمية للمخزون
        $pdo->prepare("UPDATE stock SET bags_count = bags_count + ?, total_weight = total_weight + ? WHERE product_id=?")
            ->execute([$bags, $weight, $pid]);

        $pdo->prepare("DELETE FROM sales WHERE id=?")->execute([$id]);
        header("Location: sales.php?deleted=1");
        exit;
    }
}

$products = $pdo->query('SELECT id, name FROM products ORDER BY name ASC')->fetchAll();
$sales = $pdo->query('SELECT s.*, p.name FROM sales s JOIN products p ON p.id = s.product_id ORDER BY s.id DESC')->fetchAll();
?>
<!doctype html>
<html lang="ar" dir="rtl">
<head>
<meta charset="utf-8">
<title>💰 تسجيل المبيعات</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
body { background-color: #f8f9fa; }
.card { border-radius: 15px; }
</style>
</head>
<body>

<?php include 'navbar.php'; ?>

<div class="container py-4">
  <h3 class="text-center mb-4">💰 تسجيل المبيعات</h3>

  <?php if (!empty($_GET['success'])): ?>
    <div class="alert alert-success text-center">✅ تم تسجيل البيع وتم خصم الكمية من المخزون!</div>
  <?php elseif (!empty($_GET['deleted'])): ?>
    <div class="alert alert-danger text-center">🗑️ تم حذف العملية واسترجاع الكمية!</div>
  <?php endif; ?>

  <!-- نموذج الإضافة -->
  <form method="post" enctype="multipart/form-data" class="card p-3 mb-4 shadow-sm">
    <input type="hidden" name="add_sale" value="1">
    <div class="row g-2">
      <div class="col-md-3">
        <select name="product_id" class="form-select" required>
          <option value="">اختر المادة</option>
          <?php foreach ($products as $p): ?>
          <option value="<?=$p['id']?>"><?=$p['name']?></option>
          <?php endforeach; ?>
        </select>
      </div>
      <div class="col-md-3">
        <input type="number" name="bags_sold" class="form-control" placeholder="عدد الشوالات" required>
      </div>
      <div class="col-md-3">
        <input type="number" step="0.01" name="weight_sold" class="form-control" placeholder="الوزن الكلي (كغ)" required>
      </div>
    </div>

    <div class="mt-3">
      <label>ملاحظات:</label>
      <input name="note" class="form-control" placeholder="اكتب ملاحظة (اختياري)">
    </div>

    <div class="mt-2">
      <label>صورة (اختياري):</label>
      <input type="file" name="image" class="form-control">
    </div>

    <button class="btn btn-warning mt-3 w-100">💾 حفظ البيع</button>
  </form>

  <!-- جدول المبيعات -->
  <div class="table-responsive shadow-sm">
    <table class="table table-bordered bg-white text-center align-middle">
      <thead class="table-warning">
        <tr>
          <th>المادة</th>
          <th>عدد الشوالات</th>
          <th>الوزن الكلي</th>
          <th>ملاحظات</th>
          <th>صورة</th>
          <th>تاريخ</th>
          <th>خيارات</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($sales as $s): ?>
        <tr>
          <td><?=$s['name']?></td>
          <td><?=$s['bags_sold']?></td>
          <td><?=$s['weight_sold']?></td>
          <td><?=$s['note']?></td>
          <td><?php if ($s['image']): ?><a href="<?=$s['image']?>" target="_blank">📷</a><?php endif; ?></td>
          <td><?=$s['sale_date']?></td>
          <td>
            <a href="edit_sale.php?id=<?=$s['id']?>" class="btn btn-sm btn-warning">✏️ تعديل</a>
            <a href="sales.php?delete=<?=$s['id']?>" class="btn btn-sm btn-danger" onclick="return confirm('هل تريد حذف هذه العملية؟')">🗑️ حذف</a>
          </td>
        </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div>

  <a href="index.php" class="btn btn-secondary mt-2 w-100">🏠 رجوع</a>
</div>

</body>
</html>
